<?php
// File: /public/register.php
require_once '../includes/db.php';
require_once '../includes/functions.php';

session_start();

if (isset($_SESSION['user_id'])) {
    redirect('dashboard.php');
}

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = clean($_POST['username']);
    $email = clean($_POST['email']);
    $password = $_POST['password'];
    $confirm_password = $_POST['confirm_password'];

    if (empty($username) || empty($email) || empty($password)) {
        $error = "All fields are required.";
    } elseif ($password !== $confirm_password) {
        $error = "Passwords do not match.";
    } else {
        // Check if exists
        $stmt = $pdo->prepare("SELECT id FROM users WHERE email = ? OR username = ?");
        $stmt->execute([$email, $username]);
        if ($stmt->rowCount() > 0) {
            $error = "Username or Email already exists.";
        } else {
            $hashed_password = password_hash($password, PASSWORD_DEFAULT);
            $stmt = $pdo->prepare("INSERT INTO users (username, email, password) VALUES (?, ?, ?)");
            if ($stmt->execute([$username, $email, $hashed_password])) {
                setFlash('success', 'Registration successful! Please login.');
                redirect('login.php');
            } else {
                $error = "Registration failed. Try again.";
            }
        }
    }
}

$page_title = "Register";
$no_sidebar = true;
include '../includes/header.php';
?>

<div class="auth-wrapper">
    <div class="auth-box card">
        <div class="auth-header">
            <h2>Register</h2>
            <p class="text-muted">Start your investment journey</p>
        </div>

        <?php if($error): ?>
            <div class="alert alert-danger text-danger mb-3"><?php echo $error; ?></div>
        <?php endif; ?>

        <form method="POST" action="">
            <div class="form-group">
                <label>Username</label>
                <input type="text" name="username" class="form-control" required>
            </div>
            <div class="form-group">
                <label>Email Address</label>
                <input type="email" name="email" class="form-control" required>
            </div>
            <div class="form-group">
                <label>Password</label>
                <input type="password" name="password" class="form-control" required>
            </div>
            <div class="form-group">
                <label>Confirm Password</label>
                <input type="password" name="confirm_password" class="form-control" required>
            </div>
            <button type="submit" class="btn btn-primary btn-block">Create Account</button>
        </form>
        
        <p class="mt-3 text-center text-muted">
            Already have an account? <a href="login.php" class="text-primary">Login</a>
        </p>
    </div>
</div>

<?php include '../includes/footer.php'; ?>
