<?php
// File: /public/profile.php
require_once '../includes/db.php';
require_once '../includes/auth.php';
require_once '../includes/functions.php';

requireLogin();
$user = getCurrentUser($pdo);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $new_password = $_POST['new_password'];
    
    if (!empty($new_password)) {
        $hashed = password_hash($new_password, PASSWORD_DEFAULT);
        $stmt = $pdo->prepare("UPDATE users SET password = ? WHERE id = ?");
        if ($stmt->execute([$hashed, $user['id']])) {
            setFlash('success', 'Password updated successfully.');
        } else {
            setFlash('danger', 'Failed to update password.');
        }
    } else {
        setFlash('info', 'No changes made.');
    }
    redirect('profile.php');
}

$page_title = "My Profile";
include '../includes/header.php';
?>

<div class="card" style="max-width: 600px; margin: 0 auto;">
    <h3 class="mb-4">Account Settings</h3>
    
    <div class="form-group">
        <label>Username</label>
        <input type="text" class="form-control" value="<?php echo htmlspecialchars($user['username']); ?>" disabled>
    </div>
    
    <div class="form-group">
        <label>Email Address</label>
        <input type="email" class="form-control" value="<?php echo htmlspecialchars($user['email']); ?>" disabled>
    </div>

    <hr style="border-color: var(--border-color); margin: 20px 0;">
    
    <form method="POST" action="">
        <h4 class="mb-3">Change Password</h4>
        <div class="form-group">
            <label>New Password</label>
            <input type="password" name="new_password" class="form-control" placeholder="Leave empty to keep current">
        </div>
        <button type="submit" class="btn btn-primary">Update Profile</button>
    </form>
</div>

<?php include '../includes/footer.php'; ?>
