<?php
// File: /public/login.php
require_once '../includes/db.php';
require_once '../includes/functions.php';

session_start();

if (isset($_SESSION['user_id'])) {
    redirect('dashboard.php');
}

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = clean($_POST['email']);
    $password = $_POST['password'];

    if (empty($email) || empty($password)) {
        $error = "Please fill in all fields.";
    } else {
        $stmt = $pdo->prepare("SELECT * FROM users WHERE email = ?");
        $stmt->execute([$email]);
        $user = $stmt->fetch();

        if ($user && password_verify($password, $user['password'])) {
            $_SESSION['user_id'] = $user['id'];
            $_SESSION['username'] = $user['username'];
            $_SESSION['role'] = $user['role'];
            
            if ($user['role'] === 'admin') {
                 // For simplicity, admins are also users but can access admin panel
                 // Or we can set a separate admin session
                 $_SESSION['admin_id'] = $user['id'];
                 redirect('../admin/dashboard.php');
            } else {
                redirect('dashboard.php');
            }
        } else {
            $error = "Invalid credentials.";
        }
    }
}

$page_title = "Login";
$no_sidebar = true;
include '../includes/header.php';
?>

<div class="auth-wrapper">
    <div class="auth-box card">
        <div class="auth-header">
            <h2>Login</h2>
            <p class="text-muted">Welcome back to CryptoPro</p>
        </div>
        
        <?php if($error): ?>
            <div class="alert alert-danger text-danger mb-3"><?php echo $error; ?></div>
        <?php endif; ?>

        <form method="POST" action="">
            <div class="form-group">
                <label>Email Address</label>
                <input type="email" name="email" class="form-control" required>
            </div>
            <div class="form-group">
                <label>Password</label>
                <input type="password" name="password" class="form-control" required>
            </div>
            <button type="submit" class="btn btn-primary btn-block">Login Now</button>
        </form>
        
        <p class="mt-3 text-center text-muted">
            Don't have an account? <a href="register.php" class="text-primary">Register</a>
        </p>
    </div>
</div>

<?php include '../includes/footer.php'; ?>
