<?php
// File: /includes/header.php
// Common Header with Sidebar and Topbar

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Check if we are in admin folder to adjust paths if needed, 
// but for simplicity we assume includes is included from public or admin
// We might need to adjust CSS paths.
$path_prefix = strpos($_SERVER['PHP_SELF'], '/admin/') !== false ? '../public/' : '';
// If we are in public, path_prefix is empty (or ./). 
// Actually, if we are in /public/dashboard.php, we need assets/css/style.css
// If we are in /admin/dashboard.php, we need ../public/assets/css/style.css

// Simple path detection
$is_admin = strpos($_SERVER['PHP_SELF'], '/admin/') !== false;
$assets_path = $is_admin ? '../public/assets' : 'assets';

$page_title = isset($page_title) ? $page_title : 'Crypto Invest';

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $page_title; ?></title>
    <link rel="stylesheet" href="<?php echo $assets_path; ?>/css/style.css">
    <!-- FontAwesome for Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <!-- Chart.js -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>
<body>

<?php 
// Show Sidebar and Header only if logged in and not on auth pages
$hide_sidebar = isset($no_sidebar) && $no_sidebar === true;
$is_logged_in = isset($_SESSION['user_id']) || isset($_SESSION['admin_id']);

if ($is_logged_in && !$hide_sidebar): 
    $dashboard_url = $is_admin ? 'dashboard.php' : 'dashboard.php';
    $invest_url = $is_admin ? 'investments.php' : 'invest.php';
    $tx_url = $is_admin ? 'transactions.php' : 'transactions.php'; // Admin has specific logs maybe?
    
    // User Sidebar Links
    if (!$is_admin) {
?>
    <div class="dashboard-container">
        <!-- Sidebar -->
        <aside class="sidebar" id="sidebar">
            <div class="logo">
                <i class="fab fa-bitcoin"></i> CryptoPro
            </div>
            <ul class="nav-links">
                <li><a href="dashboard.php" class="<?php echo basename($_SERVER['PHP_SELF']) == 'dashboard.php' ? 'active' : ''; ?>"><i class="fas fa-home"></i> Dashboard</a></li>
                <li><a href="deposit.php" class="<?php echo basename($_SERVER['PHP_SELF']) == 'deposit.php' ? 'active' : ''; ?>"><i class="fas fa-plus-circle"></i> Deposit</a></li>
                <li><a href="invest.php" class="<?php echo basename($_SERVER['PHP_SELF']) == 'invest.php' ? 'active' : ''; ?>"><i class="fas fa-chart-line"></i> Invest</a></li>
                <li><a href="transactions.php" class="<?php echo basename($_SERVER['PHP_SELF']) == 'transactions.php' ? 'active' : ''; ?>"><i class="fas fa-history"></i> Transactions</a></li>
                <li><a href="withdraw.php" class="<?php echo basename($_SERVER['PHP_SELF']) == 'withdraw.php' ? 'active' : ''; ?>"><i class="fas fa-wallet"></i> Withdraw</a></li>
                <li><a href="profile.php" class="<?php echo basename($_SERVER['PHP_SELF']) == 'profile.php' ? 'active' : ''; ?>"><i class="fas fa-user"></i> Profile</a></li>
                <li><a href="logout.php"><i class="fas fa-sign-out-alt"></i> Logout</a></li>
            </ul>
        </aside>

        <!-- Main Content Wrapper -->
        <main class="main-content">
            <!-- Top Header -->
            <header class="top-header">
                <div class="mobile-toggle" onclick="toggleSidebar()" style="display:none; cursor:pointer;">
                    <i class="fas fa-bars fa-lg"></i>
                </div>
                <h3><?php echo $page_title; ?></h3>
                <div class="user-menu">
                    <span>Welcome, <b><?php echo isset($_SESSION['username']) ? htmlspecialchars($_SESSION['username']) : 'User'; ?></b></span>
                    <div class="user-avatar">
                        <i class="fas fa-user"></i>
                    </div>
                </div>
            </header>
            
            <!-- Flash Messages -->
            <?php 
            if(function_exists('displayFlash')) {
                displayFlash(); 
            }
            ?>

<?php 
    } else { 
    // Admin Sidebar Links
?>
    <div class="dashboard-container">
        <!-- Sidebar -->
        <aside class="sidebar" id="sidebar">
            <div class="logo">
                <i class="fas fa-shield-alt"></i> AdminPanel
            </div>
            <ul class="nav-links">
                <li><a href="dashboard.php" class="<?php echo basename($_SERVER['PHP_SELF']) == 'dashboard.php' ? 'active' : ''; ?>"><i class="fas fa-home"></i> Dashboard</a></li>
                <li><a href="users.php" class="<?php echo basename($_SERVER['PHP_SELF']) == 'users.php' ? 'active' : ''; ?>"><i class="fas fa-users"></i> Users</a></li>
                <li><a href="deposits.php" class="<?php echo basename($_SERVER['PHP_SELF']) == 'deposits.php' ? 'active' : ''; ?>"><i class="fas fa-arrow-down"></i> Deposits</a></li>
                <li><a href="withdrawals.php" class="<?php echo basename($_SERVER['PHP_SELF']) == 'withdrawals.php' ? 'active' : ''; ?>"><i class="fas fa-arrow-up"></i> Withdrawals</a></li>
                <li><a href="investments.php" class="<?php echo basename($_SERVER['PHP_SELF']) == 'investments.php' ? 'active' : ''; ?>"><i class="fas fa-chart-pie"></i> Investments</a></li>
                <li><a href="wallets.php" class="<?php echo basename($_SERVER['PHP_SELF']) == 'wallets.php' ? 'active' : ''; ?>"><i class="fas fa-wallet"></i> Wallets</a></li>
                <li><a href="plans.php" class="<?php echo basename($_SERVER['PHP_SELF']) == 'plans.php' ? 'active' : ''; ?>"><i class="fas fa-cogs"></i> Plans</a></li>
                <li><a href="../public/logout.php"><i class="fas fa-sign-out-alt"></i> Logout</a></li>
            </ul>
        </aside>

        <!-- Main Content Wrapper -->
        <main class="main-content">
            <!-- Top Header -->
            <header class="top-header">
                <div class="mobile-toggle" onclick="toggleSidebar()" style="display:none; cursor:pointer;">
                    <i class="fas fa-bars fa-lg"></i>
                </div>
                <h3>Admin Dashboard</h3>
                <div class="user-menu">
                    <span>Admin</span>
                    <div class="user-avatar">
                        <i class="fas fa-user-shield"></i>
                    </div>
                </div>
            </header>
            
            <!-- Flash Messages -->
            <?php 
             if(function_exists('displayFlash')) {
                displayFlash(); 
            }
            ?>

<?php } // End Admin Check ?>

<?php endif; // End Logged In Check ?>
