<?php
// File: /admin/withdrawals.php
require_once '../includes/db.php';
require_once '../includes/auth.php';
require_once '../includes/functions.php';

requireAdmin();

// Handle Actions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $withdrawal_id = $_POST['withdrawal_id'];
    $action = $_POST['action'];
    
    $stmt = $pdo->prepare("SELECT * FROM withdrawals WHERE id = ?");
    $stmt->execute([$withdrawal_id]);
    $withdrawal = $stmt->fetch();

    if ($withdrawal && $withdrawal['status'] == 'pending') {
        if ($action === 'approve') {
            // Balance was already deducted when requesting
            $stmt = $pdo->prepare("UPDATE withdrawals SET status = 'approved' WHERE id = ?");
            $stmt->execute([$withdrawal_id]);
            
            logTransaction($pdo, $withdrawal['user_id'], 'withdrawal', $withdrawal['amount'], "Withdrawal Processed to " . $withdrawal['wallet_address']);
            setFlash('success', 'Withdrawal approved.');
            
        } elseif ($action === 'reject') {
            try {
                $pdo->beginTransaction();
                
                // Refund Balance
                $stmt = $pdo->prepare("UPDATE users SET balance = balance + ? WHERE id = ?");
                $stmt->execute([$withdrawal['amount'], $withdrawal['user_id']]);
                
                // Update Status
                $stmt = $pdo->prepare("UPDATE withdrawals SET status = 'rejected' WHERE id = ?");
                $stmt->execute([$withdrawal_id]);
                
                logTransaction($pdo, $withdrawal['user_id'], 'deposit', $withdrawal['amount'], "Withdrawal Refund");
                
                $pdo->commit();
                setFlash('info', 'Withdrawal rejected and refunded.');
            } catch (Exception $e) {
                $pdo->rollBack();
                setFlash('danger', 'Error: ' . $e->getMessage());
            }
        }
    }
    redirect('withdrawals.php');
}

// Fetch Withdrawals
$stmt = $pdo->query("SELECT w.*, u.username FROM withdrawals w JOIN users u ON w.user_id = u.id ORDER BY w.created_at DESC");
$withdrawals = $stmt->fetchAll();

$page_title = "Manage Withdrawals";
include '../includes/header.php';
?>

<div class="card">
    <h3 class="mb-4">Withdrawal Requests</h3>
    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th>ID</th>
                    <th>User</th>
                    <th>Amount</th>
                    <th>Wallet</th>
                    <th>Status</th>
                    <th>Date</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($withdrawals as $w): ?>
                <tr>
                    <td>#<?php echo $w['id']; ?></td>
                    <td><?php echo htmlspecialchars($w['username']); ?></td>
                    <td class="text-danger"><?php echo formatMoney($w['amount']); ?></td>
                    <td class="text-sm"><?php echo htmlspecialchars($w['wallet_address']); ?></td>
                    <td>
                        <span class="badge badge-<?php 
                            echo $w['status'] == 'approved' ? 'success' : 
                                ($w['status'] == 'rejected' ? 'danger' : 'warning'); 
                        ?>">
                            <?php echo ucfirst($w['status']); ?>
                        </span>
                    </td>
                    <td><?php echo date('M d, Y', strtotime($w['created_at'])); ?></td>
                    <td>
                        <?php if ($w['status'] == 'pending'): ?>
                        <form method="POST" style="display:inline-block;">
                            <input type="hidden" name="withdrawal_id" value="<?php echo $w['id']; ?>">
                            <button type="submit" name="action" value="approve" class="btn btn-success" style="padding: 5px 10px; font-size: 0.8rem;">Approve</button>
                            <button type="submit" name="action" value="reject" class="btn btn-danger" style="padding: 5px 10px; font-size: 0.8rem;">Reject</button>
                        </form>
                        <?php else: ?>
                            -
                        <?php endif; ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<?php include '../includes/footer.php'; ?>
