<?php
// File: /admin/wallets.php
require_once '../includes/db.php';
require_once '../includes/auth.php';
require_once '../includes/functions.php';

requireAdmin();

// Handle Actions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['add_wallet'])) {
        $name = clean($_POST['name']);
        $network = clean($_POST['network']);
        $address = clean($_POST['address']);
        
        $stmt = $pdo->prepare("INSERT INTO payment_wallets (name, network, address) VALUES (?, ?, ?)");
        if ($stmt->execute([$name, $network, $address])) {
            setFlash('success', 'Wallet added successfully.');
        } else {
            setFlash('danger', 'Failed to add wallet.');
        }
    } elseif (isset($_POST['delete_wallet'])) {
        $id = $_POST['wallet_id'];
        $stmt = $pdo->prepare("DELETE FROM payment_wallets WHERE id = ?");
        $stmt->execute([$id]);
        setFlash('success', 'Wallet deleted.');
    } elseif (isset($_POST['toggle_status'])) {
        $id = $_POST['wallet_id'];
        $current_status = $_POST['current_status'];
        $new_status = $current_status === 'active' ? 'inactive' : 'active';
        
        $stmt = $pdo->prepare("UPDATE payment_wallets SET status = ? WHERE id = ?");
        $stmt->execute([$new_status, $id]);
        setFlash('success', 'Wallet status updated.');
    } elseif (isset($_POST['edit_wallet'])) {
        $id = $_POST['wallet_id'];
        $name = clean($_POST['name']);
        $network = clean($_POST['network']);
        $address = clean($_POST['address']);
        
        $stmt = $pdo->prepare("UPDATE payment_wallets SET name = ?, network = ?, address = ? WHERE id = ?");
        $stmt->execute([$name, $network, $address, $id]);
        setFlash('success', 'Wallet updated.');
    }
    redirect('wallets.php');
}

$wallets = $pdo->query("SELECT * FROM payment_wallets ORDER BY id DESC")->fetchAll();

$page_title = "Payment Wallets";
include '../includes/header.php';
?>

<div class="card mb-4">
    <h3 class="mb-3">Add New Wallet</h3>
    <form method="POST" action="">
        <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 20px;">
            <div class="form-group">
                <label>Wallet Name</label>
                <input type="text" name="name" class="form-control" placeholder="e.g. USDT Wallet" required>
            </div>
            <div class="form-group">
                <label>Network</label>
                <input type="text" name="network" class="form-control" placeholder="e.g. TRC20" required>
            </div>
        </div>
        <div class="form-group">
            <label>Wallet Address</label>
            <input type="text" name="address" class="form-control" placeholder="Wallet Address" required>
        </div>
        <button type="submit" name="add_wallet" class="btn btn-primary">Add Wallet</button>
    </form>
</div>

<div class="card">
    <h3 class="mb-3">Manage Wallets</h3>
    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th>Name</th>
                    <th>Network</th>
                    <th>Address</th>
                    <th>Status</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($wallets as $w): ?>
                <tr>
                    <form method="POST">
                        <td><input type="text" name="name" value="<?php echo htmlspecialchars($w['name']); ?>" class="form-control" style="width: 150px;"></td>
                        <td><input type="text" name="network" value="<?php echo htmlspecialchars($w['network']); ?>" class="form-control" style="width: 100px;"></td>
                        <td><input type="text" name="address" value="<?php echo htmlspecialchars($w['address']); ?>" class="form-control"></td>
                        <td>
                            <span class="badge badge-<?php echo $w['status'] == 'active' ? 'success' : 'secondary'; ?>">
                                <?php echo ucfirst($w['status']); ?>
                            </span>
                        </td>
                        <td style="display: flex; gap: 5px;">
                            <input type="hidden" name="wallet_id" value="<?php echo $w['id']; ?>">
                            <button type="submit" name="edit_wallet" class="btn btn-primary" title="Save Changes"><i class="fas fa-save"></i></button>
                            
                            <button type="submit" name="toggle_status" class="btn btn-<?php echo $w['status'] == 'active' ? 'warning' : 'success'; ?>" title="Toggle Status">
                                <input type="hidden" name="current_status" value="<?php echo $w['status']; ?>">
                                <i class="fas fa-<?php echo $w['status'] == 'active' ? 'ban' : 'check'; ?>"></i>
                            </button>
                            
                            <button type="submit" name="delete_wallet" class="btn btn-danger" onclick="return confirm('Delete this wallet?')" title="Delete">
                                <i class="fas fa-trash"></i>
                            </button>
                        </td>
                    </form>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<?php include '../includes/footer.php'; ?>
