<?php
// File: /admin/users.php
require_once '../includes/db.php';
require_once '../includes/auth.php';
require_once '../includes/functions.php';

requireAdmin();

// Handle Actions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $user_id = $_POST['user_id'];
    
    if (isset($_POST['update_balance'])) {
        // Manual Balance Update (Reset/Set)
        $amount = $_POST['amount'];
        $stmt = $pdo->prepare("UPDATE users SET balance = ? WHERE id = ?");
        $stmt->execute([$amount, $user_id]);
        setFlash('success', 'User balance updated.');
        
    } elseif (isset($_POST['add_profit'])) {
        // Add Profit / Interest
        $amount = $_POST['amount'];
        $desc = clean($_POST['description']) ?: 'Manual Profit Added';
        
        if ($amount > 0) {
            try {
                $pdo->beginTransaction();
                
                // Add to balance
                $stmt = $pdo->prepare("UPDATE users SET balance = balance + ? WHERE id = ?");
                $stmt->execute([$amount, $user_id]);
                
                // Log transaction
                logTransaction($pdo, $user_id, 'profit', $amount, $desc);
                
                $pdo->commit();
                setFlash('success', 'Profit added successfully.');
            } catch (Exception $e) {
                $pdo->rollBack();
                setFlash('danger', 'Error: ' . $e->getMessage());
            }
        }
    }
    redirect('users.php');
}

// Fetch Users
$stmt = $pdo->query("SELECT * FROM users WHERE role = 'user' ORDER BY created_at DESC");
$users = $stmt->fetchAll();

$page_title = "Manage Users & Profits";
include '../includes/header.php';
?>

<div class="card">
    <h3 class="mb-4">Registered Users</h3>
    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th>User</th>
                    <th>Current Balance</th>
                    <th>Set Balance</th>
                    <th>Add Profit / Interest</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($users as $u): ?>
                <tr>
                    <td>
                        <div><strong><?php echo htmlspecialchars($u['username']); ?></strong></div>
                        <small class="text-muted"><?php echo htmlspecialchars($u['email']); ?></small>
                    </td>
                    <td class="text-primary font-weight-bold"><?php echo formatMoney($u['balance']); ?></td>
                    
                    <!-- Set Balance Form -->
                    <td>
                        <form method="POST" class="d-flex" style="display:flex; gap:5px;">
                            <input type="hidden" name="user_id" value="<?php echo $u['id']; ?>">
                            <input type="number" name="amount" value="<?php echo $u['balance']; ?>" step="0.01" class="form-control" style="width: 100px; padding: 5px;">
                            <button type="submit" name="update_balance" class="btn btn-secondary" style="padding: 5px 10px; font-size: 0.8rem;">Set</button>
                        </form>
                    </td>
                    
                    <!-- Add Profit Form -->
                    <td>
                        <form method="POST" class="d-flex" style="display:flex; gap:5px;">
                            <input type="hidden" name="user_id" value="<?php echo $u['id']; ?>">
                            <input type="number" name="amount" placeholder="0.00" step="0.01" class="form-control" style="width: 100px; padding: 5px;" required>
                            <input type="text" name="description" placeholder="Desc (e.g. ROI)" class="form-control" style="width: 120px; padding: 5px;">
                            <button type="submit" name="add_profit" class="btn btn-success" style="padding: 5px 10px; font-size: 0.8rem;">+ Profit</button>
                        </form>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<?php include '../includes/footer.php'; ?>
