<?php
// File: /admin/plans.php
require_once '../includes/db.php';
require_once '../includes/auth.php';
require_once '../includes/functions.php';

requireAdmin();

// Handle Add/Edit Plan
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = clean($_POST['name']);
    $roi = $_POST['roi'];
    $duration = $_POST['duration'];
    $min = $_POST['min'];
    $max = $_POST['max'];
    
    // Add new plan
    $stmt = $pdo->prepare("INSERT INTO investment_plans (name, roi_percentage, duration_days, min_amount, max_amount) VALUES (?, ?, ?, ?, ?)");
    if ($stmt->execute([$name, $roi, $duration, $min, $max])) {
        setFlash('success', 'Plan created successfully.');
    } else {
        setFlash('danger', 'Failed to create plan.');
    }
    redirect('plans.php');
}

$plans = $pdo->query("SELECT * FROM investment_plans")->fetchAll();

$page_title = "Manage Plans";
include '../includes/header.php';
?>

<div class="card mb-4">
    <h3 class="mb-3">Create New Plan</h3>
    <form method="POST" action="">
        <div class="form-group">
            <label>Plan Name</label>
            <input type="text" name="name" class="form-control" required>
        </div>
        <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 20px;">
            <div class="form-group">
                <label>ROI %</label>
                <input type="number" step="0.01" name="roi" class="form-control" required>
            </div>
            <div class="form-group">
                <label>Duration (Days)</label>
                <input type="number" name="duration" class="form-control" required>
            </div>
        </div>
        <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 20px;">
            <div class="form-group">
                <label>Min Amount</label>
                <input type="number" step="0.01" name="min" class="form-control" required>
            </div>
            <div class="form-group">
                <label>Max Amount</label>
                <input type="number" step="0.01" name="max" class="form-control" required>
            </div>
        </div>
        <button type="submit" class="btn btn-primary">Create Plan</button>
    </form>
</div>

<div class="card">
    <h3 class="mb-3">Existing Plans</h3>
    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th>Name</th>
                    <th>ROI</th>
                    <th>Duration</th>
                    <th>Min</th>
                    <th>Max</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($plans as $p): ?>
                <tr>
                    <td><?php echo htmlspecialchars($p['name']); ?></td>
                    <td><?php echo $p['roi_percentage']; ?>%</td>
                    <td><?php echo $p['duration_days']; ?> days</td>
                    <td><?php echo formatMoney($p['min_amount']); ?></td>
                    <td><?php echo formatMoney($p['max_amount']); ?></td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<?php include '../includes/footer.php'; ?>
