<?php
// File: /admin/login.php
require_once '../includes/db.php';
require_once '../includes/functions.php';

session_start();

if (isset($_SESSION['admin_id'])) {
    redirect('dashboard.php');
}

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = clean($_POST['username']);
    $password = $_POST['password'];

    if (empty($username) || empty($password)) {
        $error = "Please fill in all fields.";
    } else {
        // Check users table for role='admin'
        $stmt = $pdo->prepare("SELECT * FROM users WHERE (username = ? OR email = ?) AND role = 'admin'");
        $stmt->execute([$username, $username]);
        $user = $stmt->fetch();

        if ($user && password_verify($password, $user['password'])) {
            $_SESSION['user_id'] = $user['id']; // Also set user_id for shared logic
            $_SESSION['admin_id'] = $user['id'];
            $_SESSION['username'] = $user['username'];
            $_SESSION['role'] = 'admin';
            redirect('dashboard.php');
        } else {
            $error = "Invalid admin credentials.";
        }
    }
}

$page_title = "Admin Login";
$no_sidebar = true;
include '../includes/header.php';
?>

<div class="auth-wrapper">
    <div class="auth-box card" style="border-top: 4px solid var(--accent-red);">
        <div class="auth-header">
            <h2>Admin Panel</h2>
            <p class="text-muted">Restricted Access</p>
        </div>
        
        <?php if($error): ?>
            <div class="alert alert-danger text-danger mb-3"><?php echo $error; ?></div>
        <?php endif; ?>

        <form method="POST" action="">
            <div class="form-group">
                <label>Username or Email</label>
                <input type="text" name="username" class="form-control" required>
            </div>
            <div class="form-group">
                <label>Password</label>
                <input type="password" name="password" class="form-control" required>
            </div>
            <button type="submit" class="btn btn-danger btn-block">Login as Admin</button>
        </form>
        
        <p class="mt-3 text-center text-muted">
            <a href="../public/login.php" class="text-primary">Back to User Login</a>
        </p>
    </div>
</div>

<?php include '../includes/footer.php'; ?>
