<?php
// File: /admin/investments.php
require_once '../includes/db.php';
require_once '../includes/auth.php';
require_once '../includes/functions.php';

requireAdmin();

// Handle Add ROI to Investment
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['add_roi'])) {
    $inv_id = $_POST['investment_id'];
    $user_id = $_POST['user_id'];
    $amount = $_POST['amount'];
    
    if ($amount > 0) {
        try {
            $pdo->beginTransaction();
            
            // Add profit to investments table (optional, but good for tracking)
            $stmt = $pdo->prepare("UPDATE investments SET profit_earned = profit_earned + ? WHERE id = ?");
            $stmt->execute([$amount, $inv_id]);
            
            // Add to User Balance
            $stmt = $pdo->prepare("UPDATE users SET balance = balance + ? WHERE id = ?");
            $stmt->execute([$amount, $user_id]);
            
            // Log Transaction
            logTransaction($pdo, $user_id, 'profit', $amount, "ROI for Investment #$inv_id");
            
            $pdo->commit();
            setFlash('success', 'ROI added to investment successfully.');
        } catch (Exception $e) {
            $pdo->rollBack();
            setFlash('danger', 'Error: ' . $e->getMessage());
        }
    }
    redirect('investments.php');
}

$stmt = $pdo->query("
    SELECT i.*, u.username, p.name as plan_name 
    FROM investments i 
    JOIN users u ON i.user_id = u.id 
    JOIN investment_plans p ON i.plan_id = p.id 
    ORDER BY i.start_date DESC
");
$investments = $stmt->fetchAll();

$page_title = "Manage Investments";
include '../includes/header.php';
?>

<div class="card">
    <h3 class="mb-4">Investment History</h3>
    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th>ID</th>
                    <th>User</th>
                    <th>Plan</th>
                    <th>Invested</th>
                    <th>Profit Earned</th>
                    <th>Status</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($investments as $inv): ?>
                <tr>
                    <td>#<?php echo $inv['id']; ?></td>
                    <td><?php echo htmlspecialchars($inv['username']); ?></td>
                    <td><?php echo htmlspecialchars($inv['plan_name']); ?></td>
                    <td><?php echo formatMoney($inv['amount']); ?></td>
                    <td class="text-success"><?php echo formatMoney($inv['profit_earned']); ?></td>
                    <td>
                        <span class="badge badge-<?php echo $inv['status'] == 'active' ? 'success' : 'secondary'; ?>">
                            <?php echo ucfirst($inv['status']); ?>
                        </span>
                    </td>
                    <td>
                        <?php if ($inv['status'] == 'active'): ?>
                        <form method="POST" class="d-flex" style="display:flex; gap:5px;">
                            <input type="hidden" name="investment_id" value="<?php echo $inv['id']; ?>">
                            <input type="hidden" name="user_id" value="<?php echo $inv['user_id']; ?>">
                            <input type="number" name="amount" placeholder="ROI Amount" step="0.01" class="form-control" style="width: 100px; padding: 5px;" required>
                            <button type="submit" name="add_roi" class="btn btn-success" style="padding: 5px 10px; font-size: 0.8rem;">Add ROI</button>
                        </form>
                        <?php else: ?>
                            Completed
                        <?php endif; ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<?php include '../includes/footer.php'; ?>
