<?php
// File: /admin/dashboard.php
require_once '../includes/db.php';
require_once '../includes/auth.php';
require_once '../includes/functions.php';

requireAdmin();

// Admin Stats
$stats = [];

// Total Users
$stmt = $pdo->query("SELECT COUNT(*) FROM users WHERE role = 'user'");
$stats['users'] = $stmt->fetchColumn();

// Total Investments
$stmt = $pdo->query("SELECT SUM(amount) FROM investments WHERE status = 'active'");
$stats['active_investments'] = $stmt->fetchColumn() ?: 0;

// Pending Withdrawals
$stmt = $pdo->query("SELECT COUNT(*) FROM withdrawals WHERE status = 'pending'");
$stats['pending_withdrawals'] = $stmt->fetchColumn();

// Total Deposits
$stmt = $pdo->query("SELECT SUM(amount) FROM transactions WHERE type = 'deposit'");
$stats['total_deposits'] = $stmt->fetchColumn() ?: 0;

$page_title = "Admin Dashboard";
include '../includes/header.php';
?>

<div class="stats-grid">
    <div class="stat-card">
        <div class="stat-title">Total Users</div>
        <div class="stat-value"><?php echo $stats['users']; ?></div>
        <a href="users.php" class="text-primary text-sm">Manage Users</a>
    </div>
    <div class="stat-card">
        <div class="stat-title">Active Investments</div>
        <div class="stat-value text-success"><?php echo formatMoney($stats['active_investments']); ?></div>
        <a href="investments.php" class="text-primary text-sm">View All</a>
    </div>
    <div class="stat-card">
        <div class="stat-title">Pending Withdrawals</div>
        <div class="stat-value text-danger"><?php echo $stats['pending_withdrawals']; ?></div>
        <a href="withdrawals.php" class="text-primary text-sm">Review Requests</a>
    </div>
    <div class="stat-card">
        <div class="stat-title">Total Deposits</div>
        <div class="stat-value text-primary"><?php echo formatMoney($stats['total_deposits']); ?></div>
        <a href="deposits.php" class="text-primary text-sm">View History</a>
    </div>
</div>

<div class="card">
    <h3 class="mb-3">System Overview</h3>
    <p>Welcome to the admin control panel. Use the sidebar to manage users, approve transactions, and configure investment plans.</p>
</div>

<?php include '../includes/footer.php'; ?>
